# Generated Python Strategy for: PlayerA (meta)
# Run Index: 6
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run6_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    def analyze_opponent_code(code):
        # Simple keyword checks
        keywords_cooperate = ["return 'C'", "return C", "always_cooperate", "COOPERATE", "cooperate"]
        keywords_defect = ["return 'D'", "return D", "always_defect", "DEFECT", "defect"]
        keywords_tit_for_tat = ["tit_for_tat", "TitForTat", "opp_history[-1]", "my_history[-1]"]
        
        # Count occurrences
        coop_score = sum(code.count(kw) for kw in keywords_cooperate)
        defect_score = sum(code.count(kw) for kw in keywords_defect)
        tft_score = sum(code.count(kw) for kw in keywords_tit_for_tat)
        
        # Check for suspicious patterns (e.g., random choice, always defect)
        suspicious = ("random.choice(['C', 'D'])" in code or 
                     "random.choice(['D', 'C'])" in code or 
                     "random.choices(['C', 'D'])" in code or
                     "random.choices(['D', 'C'])" in code or
                     "return 'D'" in code or
                     "return D" in code)
        
        # Check for self-referential or meta-agent patterns (e.g., checking opponent's code)
        is_meta = "opponent_program_code" in code or "make_internal_llm_call" in code
        
        # Simple length heuristic
        code_length = len(code.splitlines())
        if code_length < 5:
            return "simple_cooperate"  # Assume short code is simple/cooperative
        elif code_length > 100:
            return "complex_cautious"  # Assume long code is complex/possibly exploitative
        
        # Decision based on scores
        if coop_score > defect_score + 2:
            return "likely_cooperate"
        elif defect_score > coop_score + 2:
            return "likely_defect"
        elif tft_score > 1:
            return "likely_tit_for_tat"
        elif suspicious:
            return "likely_defect"
        elif is_meta:
            return "meta_cautious"
        else:
            return "unknown"
    
    analysis_result = analyze_opponent_code(opponent_program_code)
    
    # Decision logic based on analysis and history
    if analysis_result == "likely_cooperate":
        return "C"
    elif analysis_result == "likely_defect":
        return "D"
    elif analysis_result == "likely_tit_for_tat":
        # Mirror opponent's last move if Tit-for-Tat-like
        return opp_history[-1] if opp_history else "C"
    elif analysis_result == "simple_cooperate":
        return "C"
    elif analysis_result == "complex_cautious" or analysis_result == "meta_cautious":
        # Be cautious with complex/meta agents: Tit-for-Tat with occasional defection
        if len(my_history) > 10 and sum(1 for m in opp_history[-5:] if m == "D") >= 3:
            return "D"
        return opp_history[-1] if opp_history else "C"
    else:
        # Fallback: Tit-for-Tat
        return opp_history[-1] if opp_history else "C"